using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace Find_Method_SqlClient {
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form {
        private SqlConnection cn;
        private SqlCommand cmd; 
        private SqlDataAdapter da; 
        private DataSet ds; 
        private int i; 
        private object objDb;  

        internal System.Windows.Forms.TextBox txtFoundRow;
        internal System.Windows.Forms.TextBox txtFindArg;
        internal System.Windows.Forms.Button btnFind;
        internal System.Windows.Forms.DataGrid DataGrid1;
        internal System.Windows.Forms.Button btnFindArray;
        internal System.Windows.Forms.Button btnFindRow;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1() {
            try {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //

                cn = new SqlConnection("server=.;database=biblio;uid=admin;pwd=pw");
                cmd = new SqlCommand("Select Title_ID, Title, Price, PubDate from Pubs..Titles",cn);
                cmd.CommandType = CommandType.Text;
                da = new SqlDataAdapter(cmd);
                ds= new DataSet();
                RunQuery();


            }
            catch(Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }



        private void RunQuery() {
            try {
                DataColumn[] dcPk = new DataColumn[1];

                da.Fill(ds, "Titles");
                ds.Tables[0].DefaultView.Sort = "Title_ID";
                objDb = DataGrid1.DataSource;
                DataGrid1.DataSource = ds.Tables[0];
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.txtFoundRow = new System.Windows.Forms.TextBox();
            this.txtFindArg = new System.Windows.Forms.TextBox();
            this.btnFind = new System.Windows.Forms.Button();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            this.btnFindArray = new System.Windows.Forms.Button();
            this.btnFindRow = new System.Windows.Forms.Button();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // txtFoundRow
            // 
            this.txtFoundRow.Location = new System.Drawing.Point(24, 112);
            this.txtFoundRow.Name = "txtFoundRow";
            this.txtFoundRow.Size = new System.Drawing.Size(496, 20);
            this.txtFoundRow.TabIndex = 16;
            this.txtFoundRow.Text = "";
            // 
            // txtFindArg
            // 
            this.txtFindArg.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtFindArg.Location = new System.Drawing.Point(168, 16);
            this.txtFindArg.Name = "txtFindArg";
            this.txtFindArg.Size = new System.Drawing.Size(200, 22);
            this.txtFindArg.TabIndex = 14;
            this.txtFindArg.Text = "BU7832";
            // 
            // btnFind
            // 
            this.btnFind.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.btnFind.Location = new System.Drawing.Point(24, 72);
            this.btnFind.Name = "btnFind";
            this.btnFind.Size = new System.Drawing.Size(104, 24);
            this.btnFind.TabIndex = 13;
            this.btnFind.Text = "Find";
            this.btnFind.Click += new System.EventHandler(this.btnFind_Click);
            // 
            // DataGrid1
            // 
            this.DataGrid1.AlternatingBackColor = System.Drawing.Color.LightGray;
            this.DataGrid1.BackColor = System.Drawing.Color.DarkGray;
            this.DataGrid1.CaptionBackColor = System.Drawing.Color.White;
            this.DataGrid1.CaptionFont = new System.Drawing.Font("Verdana", 10F);
            this.DataGrid1.CaptionForeColor = System.Drawing.Color.Navy;
            this.DataGrid1.DataMember = "";
            this.DataGrid1.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.DataGrid1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.DataGrid1.ForeColor = System.Drawing.Color.Black;
            this.DataGrid1.GridLineColor = System.Drawing.Color.Black;
            this.DataGrid1.GridLineStyle = System.Windows.Forms.DataGridLineStyle.None;
            this.DataGrid1.HeaderBackColor = System.Drawing.Color.Silver;
            this.DataGrid1.HeaderForeColor = System.Drawing.Color.Black;
            this.DataGrid1.LinkColor = System.Drawing.Color.Navy;
            this.DataGrid1.Location = new System.Drawing.Point(0, 197);
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.ParentRowsBackColor = System.Drawing.Color.White;
            this.DataGrid1.ParentRowsForeColor = System.Drawing.Color.Black;
            this.DataGrid1.SelectionBackColor = System.Drawing.Color.Navy;
            this.DataGrid1.SelectionForeColor = System.Drawing.Color.White;
            this.DataGrid1.Size = new System.Drawing.Size(536, 288);
            this.DataGrid1.TabIndex = 10;
            // 
            // btnFindArray
            // 
            this.btnFindArray.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.btnFindArray.Location = new System.Drawing.Point(144, 72);
            this.btnFindArray.Name = "btnFindArray";
            this.btnFindArray.Size = new System.Drawing.Size(104, 24);
            this.btnFindArray.TabIndex = 11;
            this.btnFindArray.Text = "Find Array";
            this.btnFindArray.Click += new System.EventHandler(this.btnFindArray_Click);
            // 
            // btnFindRow
            // 
            this.btnFindRow.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.btnFindRow.Location = new System.Drawing.Point(264, 72);
            this.btnFindRow.Name = "btnFindRow";
            this.btnFindRow.Size = new System.Drawing.Size(104, 24);
            this.btnFindRow.TabIndex = 12;
            this.btnFindRow.Text = "Find Row";
            this.btnFindRow.Click += new System.EventHandler(this.btnFindRow_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(536, 485);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.txtFoundRow,
                                                                          this.txtFindArg,
                                                                          this.btnFind,
                                                                          this.DataGrid1,
                                                                          this.btnFindArray,
                                                                          this.btnFindRow});
            this.Name = "Form1";
            this.Text = "Form1";
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new Form1());
        }

        private void btnFind_Click(object sender, System.EventArgs e) {
            try {
                int intRow;
                intRow = ds.Tables[0].DefaultView.Find(txtFindArg.Text);
                Debug.WriteLine(intRow);
                if (intRow == -1) {
                    MessageBox.Show("No PK matches " + txtFindArg.Text);
                }
                else {
                    DataGrid1.CurrentRowIndex = intRow;
                }
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }

        private void btnFindArray_Click(object sender, System.EventArgs e) {
            try {
                int intRow;
                object[] objPkArgs = new object[1];
                objPkArgs[0] = txtFindArg.Text;    // contains valid PK
                intRow = ds.Tables[0].DefaultView.Find(objPkArgs);
                Debug.WriteLine(intRow);
                if (intRow == -1) {
                    MessageBox.Show("No PK matches " + txtFindArg.Text);
                }
                else {
                    DataGrid1.CurrentRowIndex = intRow;
                }
            }
            catch(Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }
        private void btnFindRow_Click(object sender, System.EventArgs e) {
            try {
                DataRow drFound;
                DataColumn[] colPk = new DataColumn[2];
                colPk[0] = ds.Tables[0].Columns["Title_ID"];
                ds.Tables[0].PrimaryKey = colPk;
                drFound = ds.Tables[0].Rows.Find(txtFindArg.Text);
                if (drFound ==null ) {
                    MessageBox.Show("No PK matches " + txtFindArg.Text);
                }
                else {
                    txtFoundRow.Text = drFound[0].ToString() + " : " + drFound["Title"].ToString();
                }
            }
            catch(Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());

            }
        }
    }
}